@echo off
SetLocal EnableDelayedExpansion

set BUILD_DIR=%cd%
set BUILD_DIR=%BUILD_DIR:\=/%
set BUILD_DIR=!BUILD_DIR:%WORKSPACE_DIR%=/workspace!

if not "%VAR_SPECFILE%" == "" (
    SET VAR_SPECFILE=--specfile "%VAR_SPECFILE%"
    SET VAR_SPECFILE=!VAR_SPECFILE:%WORKSPACE_DIR%=/workspace!
) else (
    SET VAR_SPECFILE=
)

@REM it is necessary for the correct replacement in the QtCreatorDeployment.txt
if exist .cmake\api\v1\query (
    rmdir /s /q .cmake\api\v1\query
)

if not exist .env.list (
    type nul > ".env.list"
)

docker run -i --rm --env-file .env.list --cap-add=SYS_ADMIN --security-opt apparmor:unconfined -v %WORKSPACE_DIR%:/workspace -w %BUILD_DIR% @docker_image_tag@ apptool %* %VAR_SPECFILE%

if exist QtCreatorDeployment.txt (
    powershell -Command "(gc QtCreatorDeployment.txt) -replace '/workspace', '%WORKSPACE_DIR%' | Out-File QtCreatorDeployment.txt"
)
